Rem
Rem $Header: sdo/demo/georaster/plsql/compress_georaster.sql /main/5 2012/10/09 12:32:38 zzhang Exp $
Rem
Rem compress_georaster.sql
Rem
Rem Copyright (c) 2004, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      compress_georaster.sql 
Rem
Rem    DESCRIPTION
Rem      demonstrates JPEG-F/DEFLATE compression/decompression
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    wexu        05/04/05 - update
Rem    wexu        08/18/04 - comments
Rem    wexu        08/10/04 - add comments
Rem    wexu        08/05/04 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

-----------------------------------------------------------------------------
-- You can call sdo_geor.getCompressionType to find out whether a GeoRaster
-- object is compressed or not, and if it is, what the compression type is.
-- Call sdo_geor.calcCompressionRatio to calculate the compression ratio of 
-- a specified GeoRaster object on the fly. 
-----------------------------------------------------------------------------

select substr(sdo_geor.getCompressionType(georaster),1,15) comptype,
       sdo_geor.calcCompressionRatio(georaster) compRatio 
  from georaster_table
 where georid = 1;

-----------------------------------------------------------------------------
-- You can specify the compression type as part of the storage parameter
-- in procedure changeFormatCopy, subset, scaleCopy and mosaic. In the 
-- following example, the result GeoRaster object is reblocked and compressed
-- with DEFLATE compression type. Note that DEFLATE compression is loseless, 
-- while JPEG-F are lossy compression formats.
-----------------------------------------------------------------------------

declare
  gr1 sdo_georaster;
  gr2 sdo_georaster;
begin
  select georaster into gr1 from georaster_table where georid=1;
  insert into georaster_table 
    values (11, 'DEFLATE', sdo_geor.init('ST_RDT_1'))
    returning georaster into gr2;
  sdo_geor.changeFormatCopy(gr1, 'blocksize=(256,128,3) compression=DEFLATE',
                            gr2);
  update georaster_table set georaster=gr2 where georid=11;
  commit;
end;
/

select substr(sdo_geor.getCompressionType(georaster),1,15) comptype,
       sdo_geor.calcCompressionRatio(georaster) compRatio
  from georaster_table
 where georid = 11;

-----------------------------------------------------------------------------
-- You can specify whether the result LOB data of sdo_geor.getRasterSubset
-- is compressed or not. In the following example, the subset result 
-- is compressed with JPEG-F type.
-----------------------------------------------------------------------------
declare
  gr sdo_georaster;
  lb blob;
begin
  select georaster into gr from georaster_table where georid=11;
  dbms_lob.createTemporary(lb, FALSE);
  sdo_geor.getRasterSubset(gr, 0, sdo_number_array(0,0,99,99), null,
                          lb, 'compression=JPEG-F');
  -- write to file
  -- ...
  dbms_lob.freeTemporary(lb);
end;
/


-----------------------------------------------------------------------------
-- Note that JPEG-F compression only works on GeoRaster objects with 
-- 8BIT_U cell depth.
--
-- An optional "quality" parameter can be specified when the compression type
-- is JPEG-F. The "quality" parameter value must be an integer 
-- between 0 (lowest quality) and 100 (highest quality). The default qulity 
-- value is 75.
-----------------------------------------------------------------------------

declare
  gr1 sdo_georaster;
  gr2 sdo_georaster;
begin
  select georaster into gr1 from georaster_table where georid=1;
  insert into georaster_table
    values (12, 'JPEG-F', sdo_geor.init('ST_RDT_1'))
    returning georaster into gr2;
  sdo_geor.changeFormatCopy(gr1, 'compression=JPEG-F quality=50', gr2);
  update georaster_table set georaster=gr2 where georid=12;
  commit;
end;
/

select substr(sdo_geor.getCompressionType(georaster),1,15) comptype,
       sdo_geor.calcCompressionRatio(georaster) compRatio
  from georaster_table
 where georid = 12;

declare
  gr1 sdo_georaster;
  gr2 sdo_georaster;
begin
  select georaster into gr1 from georaster_table where georid=12;
  insert into georaster_table
    values (13, 'NONE', sdo_geor.init('ST_RDT_1'))
    returning georaster into gr2;
  sdo_geor.subset(gr1, sdo_number_array(10,10,249,249), null, 
                  'blocking=false compression=NONE', gr2);
  update georaster_table set georaster=gr2 where georid=13;
  commit;
end;
/

select substr(sdo_geor.getCompressionType(georaster),1,15) comptype,
       sdo_geor.calcCompressionRatio(georaster) compRatio
  from georaster_table
 where georid = 13;

select substr(sdo_geor.validateGeoRaster(georaster),1,15) isValid
  from georaster_table
 where georid = 13;



---------------------------------------------------------------------
-- In the following example we build pyramids on a GeoRaster object, 
-- and then compress it with JPEG-F type. 
---------------------------------------------------------------------

declare
  gr1 sdo_georaster;
  gr2 sdo_georaster;
begin
  select georaster into gr1 from georaster_table where georid=1;
  insert into georaster_table
    values (14, 'JPEG-F', sdo_geor.init('ST_RDT_2'))
    returning georaster into gr2;
  sdo_geor.generatePyramid(gr1, 'resampling=NN');
  sdo_geor.changeFormatCopy(gr1, 'compression=JPEG-F',gr2);
  update georaster_table set georaster=gr2 where georid=14;
  commit;
end;
/

select substr(sdo_geor.getCompressionType(georaster),1,15) comptype,
       sdo_geor.getPyramidMaxLevel(georaster) maxlevel,
       sdo_geor.calcCompressionRatio(georaster) compRatio
  from georaster_table
 where georid=14;





